/*
 * def.h
 * 
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * See the COPYING file.
 */


#ifndef __DEF_H__
#define __DEF_H__

#ifndef _GNU_SOURCE
#define _GNU_SOURCE
#endif

#include "unistd.h"
#include <syslog.h>

#define log_info( format, ... ) \
   do { \
	   syslog( LOG_DAEMON | LOG_INFO, format, __VA_ARGS__ ); \
   } while(0)

#define log_error( format, ... ) \
   do { \
	   syslog( LOG_DAEMON | LOG_PERROR, format, __VA_ARGS__ ); \
   } while(0)

#define log_warn( format, ... ) \
   do { \
	   syslog( LOG_DAEMON | LOG_WARNING, format, __VA_ARGS__ ); \
   } while(0)
   
extern const char *progname;

#endif // __DEF_H__

