#include <gtk/gtk.h>
#include <string.h>
#include <stdio.h>
#include <errno.h>
#include <stdbool.h>
#include <ctype.h>
#include <assert.h>
#include "hopman.h"
#include "gui.h"


static int debug = -1;

static
int compare_alpha(char *a, char *b)
{
  while(isalpha(*a) && isalpha(*b))
    {
      if (*a != *b)
        break;
      a++;
      b++;
    }
  if(isalpha(*a) || isalpha(*b))
    return 0;
  else
    return 1;
}

// Usage: strncpy_t(str1, sizeof(str1), str2, strlen(str2));
// Copy string "in" with at most "insz" chars to buffer "out", which
// is "outsz" bytes long. The output is always 0-terminated. Unlike
// strncpy(), strncpy_t() does not zero fill remaining space in the
// output buffer:
static
char* strncpy_t(char* out, size_t outsz, const char* in, size_t insz)
{
   assert(outsz > 0);
   while(--outsz > 0 && insz > 0 && *in) { *out++ = *in++; insz--; }
   *out = 0;
   return out;
} 	

void ui_create(partinfo_t *p)
{
  gint h = 5, pos = 0, rc = 1;
  GList *Ch1 = NULL;
  GtkWidget *pMenu=NULL;
  GtkWidget *pMenuItem=NULL;
  GtkWidget *pSeparator=NULL;
  GtkWidget *pSpacer=NULL;
  GtkWidget *pHbox=NULL;
  GtkWidget *pLname=NULL, *pLlabel=NULL, *pLfstype=NULL, *pLsize=NULL, *pLmnt=NULL;
  GtkWidget *pMount=NULL, *pUmount=NULL, *pOpen=NULL, *pTerm=NULL;
  GtkWidget *pEject=NULL;
  guint myshowflags = showflags;
  bool shall_break = false;
  char prev[PM_NAME_LEN+1]={0};

  /* create the action menu and associated submenu item to put it in menubar */
  pMenu     = gtk_menu_new();
  pMenuItem = gtk_menu_item_new();
  
  gtk_menu_item_set_submenu( GTK_MENU_ITEM(pMenuItem), pMenu );

  /* create an hbox to fill the label of the menuitem */
#if GTK_MAJOR_VERSION == 2
  pHbox = gtk_hbox_new(FALSE, 10); 
#elif GTK_MAJOR_VERSION == 3
  pHbox = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 10);   
#endif
  gtk_container_add(GTK_CONTAINER(pMenuItem), pHbox);

  /* fill the hbox with partition's name, label, fstype, mountpoint */
  if(showflags & SHOWNAME)
    {
      char Item[PM_NAME_LEN+1]={0};
      pLname = gtk_label_new(NULL);
      strncpy_t(Item, sizeof(Item), p->name, strlen(p->name));
      gtk_label_set_markup_with_mnemonic(GTK_LABEL(pLname), Item);  
      //gtk_container_add (GTK_CONTAINER (gtk_box_pack_start (pHbox), pLname);
      gtk_box_pack_start (GTK_BOX(pHbox), pLname, FALSE, FALSE, 0);
    }
  if((showflags & SHOWLABEL) || !(showflags & SHOWNAME) )
    {
      char Item[PM_NAME_LEN+PM_LABEL_LEN+4]={0};
      // if name is not shown, label is shown - replaced by name if absent
      pLlabel = gtk_label_new(NULL);
      strncpy_t(Item, sizeof(Item), p->name, strlen(p->name));
      if((p->label[0]) || (showflags & SHOWNAME)) {
        strcat(Item, " (");
        strcat(Item, p->label);
        strcat(Item, ")");
      }
      gtk_label_set_markup_with_mnemonic(GTK_LABEL(pLlabel), Item);  
      //gtk_container_add (GTK_CONTAINER (gtk_box_pack_start (pHbox), pLlabel);
      gtk_box_pack_start (GTK_BOX(pHbox), pLlabel, FALSE, FALSE, 0);
    }
  if(myshowflags & SHOWFSTYPE)
    {
      char Item[PM_FSTYPE_LEN+1]={0};
      pLfstype = gtk_label_new(NULL);
      strncpy_t(Item, sizeof(Item), p->fstype, strlen(p->fstype));
#if GTK_MAJOR_VERSION == 2
      GdkColor color;
      gdk_color_parse ("grey", &color);
      gtk_widget_modify_fg (pLfstype, GTK_STATE_NORMAL, &color);
#elif GTK_MAJOR_VERSION == 3
      GdkRGBA rgba;
      gdk_rgba_parse (&rgba, "grey");
      gtk_widget_override_color (pLfstype, 0, &rgba);
      //gtk_widget_modify_fg (pLfstype, GTK_STATE_NORMAL, &rgba); 
#endif   
      gtk_label_set_markup_with_mnemonic(GTK_LABEL(pLfstype), Item);  
      //gtk_container_add (GTK_CONTAINER (gtk_box_pack_start (pHbox), pLfstype);
      gtk_box_pack_start (GTK_BOX(pHbox), pLfstype, FALSE, FALSE, 0);
    }
  if(myshowflags & SHOWSIZE)
    {
      char Item[PM_SIZE_LEN+1]={0};
      pLsize = gtk_label_new(NULL);
      strncpy_t(Item, sizeof(Item), p->size, strlen(p->size));
#if GTK_MAJOR_VERSION == 2
      GdkColor color;
      gdk_color_parse ("maroon", &color);
      gtk_widget_modify_fg (pLsize, GTK_STATE_NORMAL, &color);
#elif GTK_MAJOR_VERSION == 3
      GdkRGBA rgba;
      gdk_rgba_parse (&rgba, "maroon");
      gtk_widget_override_color (pLsize, 0, &rgba);
      //gtk_widget_modify_fg (pLsize, GTK_STATE_NORMAL, &rgba); 
#endif
      gtk_label_set_markup_with_mnemonic(GTK_LABEL(pLsize), Item);
      //gtk_container_add (GTK_CONTAINER (gtk_box_pack_start (pHbox), pLsize);
      gtk_box_pack_start (GTK_BOX(pHbox), pLsize, FALSE, FALSE, 0);
    }
  if(myshowflags & SHOWMNT)
    {
      char Item[PM_MNT_LEN+1]={0};
      pLmnt = gtk_label_new(NULL);  
      strncpy_t(Item, sizeof(Item), p->mnt, strlen(p->mnt));
#if GTK_MAJOR_VERSION == 2
      GdkColor color;
      gdk_color_parse ("blue", &color);
      gtk_widget_modify_fg (pLmnt, GTK_STATE_NORMAL, &color);
#elif GTK_MAJOR_VERSION == 3
      GdkRGBA rgba;
      gdk_rgba_parse (&rgba, "blue");
      gtk_widget_override_color (pLmnt, 0, &rgba);
      //gtk_widget_modify_fg (pLmnt, GTK_STATE_NORMAL, &rgba); 
#endif
      gtk_label_set_markup_with_mnemonic(GTK_LABEL(pLmnt), Item);
      //gtk_container_add (GTK_CONTAINER (gtk_box_pack_start (pHbox), pLmnt);
      gtk_box_pack_end (GTK_BOX(pHbox), pLmnt, FALSE, FALSE, 10);
    }

  /* create the menuitems for the submenu and connect them to the callbacks */
  pOpen  = gtk_menu_item_new_with_label(_("Open in file-manager"));
  gtk_menu_shell_append(GTK_MENU_SHELL(pMenu), pOpen);
  g_signal_connect(G_OBJECT(pOpen), "activate", G_CALLBACK(on_click_open),
           (gpointer)p );
  pTerm  = gtk_menu_item_new_with_label(_("Open in terminal"));
  gtk_menu_shell_append(GTK_MENU_SHELL(pMenu), pTerm);
  g_signal_connect(G_OBJECT(pTerm), "activate", G_CALLBACK(on_click_term),
           (gpointer)p );
  pMount = gtk_menu_item_new_with_label(_("Mount"));
  gtk_menu_shell_append(GTK_MENU_SHELL(pMenu), pMount);
  g_signal_connect(G_OBJECT(pMount), "activate", G_CALLBACK(on_click_mount),
           (gpointer)p );
  pUmount= gtk_menu_item_new_with_label(_("Umount"));
  gtk_menu_shell_append(GTK_MENU_SHELL(pMenu), pUmount);
  g_signal_connect(G_OBJECT(pUmount), "activate", G_CALLBACK(on_click_umount),
           (gpointer)p );
  pEject= gtk_menu_item_new_with_label("_(Eject)");
  gtk_menu_shell_append(GTK_MENU_SHELL(pMenu), pEject);
  g_signal_connect(G_OBJECT(pEject), "activate", G_CALLBACK(on_click_eject),
           (gpointer)p );

  if( p->nmounts ) 
	  gtk_widget_set_sensitive(pMount, FALSE);
  else
	  gtk_widget_set_sensitive(pUmount, FALSE);
  
  // determine position and remove separators
  Ch1 = gtk_container_get_children(GTK_CONTAINER(pList));
  for (GList * iter1 = Ch1; iter1 != NULL; iter1 = iter1->next) {
     const char *type = gtk_widget_get_name(GTK_WIDGET(iter1->data));
     if(!g_strcmp0(type, "GtkSeparatorMenuItem")) {
		gtk_container_remove( GTK_CONTAINER(pList), GTK_WIDGET(iter1->data) );
        continue;
     }
     if(shall_break) continue;   
	 GList *Ch2 = gtk_container_get_children(GTK_CONTAINER(iter1->data));
     for (GList *iter2 = Ch2; iter2 != NULL; iter2 = iter2->next) {
        GList *Ch3 = gtk_container_get_children(GTK_CONTAINER(iter2->data));
        GList *first = g_list_first(Ch3);
	    char *lbl = strdup((char*)gtk_label_get_text(GTK_LABEL(first->data)));
		char *token = strsep(&lbl, " ");
	    if(g_strcmp0(p->name, token)>0) pos++;
	    else shall_break = true;
        g_list_free(Ch3);
     }
     // Do not break the loop even if shall_break == true
     // we need to continue removing the rest of separators       
     g_list_free(Ch2);
  }
  g_list_free(Ch1);
  
  gtk_menu_shell_insert(GTK_MENU_SHELL(pList), pMenuItem, pos);
  
  // restore separators
  pos = 0;
  Ch1 = gtk_container_get_children(GTK_CONTAINER(pList));
  for (GList * iter1 = Ch1; iter1 != NULL; iter1 = iter1->next) {
	 GList *Ch2 = gtk_container_get_children(GTK_CONTAINER(iter1->data));
     for (GList *iter2 = Ch2; iter2 != NULL; iter2 = iter2->next) {
        GList *Ch3 = gtk_container_get_children(GTK_CONTAINER(iter2->data));
        GList *first = g_list_first(Ch3);
	    char *lbl = strdup((char*)gtk_label_get_text(GTK_LABEL(first->data)));
		char *token = strsep(&lbl, " ");
		if(*prev && compare_alpha(token, prev) == 0) {
		   GtkWidget *pSeparator = gtk_separator_menu_item_new();
           gtk_menu_shell_insert(GTK_MENU_SHELL(pList), pSeparator, pos);
           pos++;
		}
	    memset(&prev, 0, sizeof(prev));  
		strncpy_t(prev, sizeof(prev), token, strlen(token));
     }      
     g_list_free(Ch2);
     pos++;  
  }
  g_list_free(Ch1);  

  gtk_widget_show_all(pList);
  ui_set_visible(1);
}

void ui_delete(partinfo_t *p)
{
  int pos = 0;
  char prev[PM_NAME_LEN+1]={0};
  bool is_empty = false;
  bool found_ok = false;

  GList *Ch1 = gtk_container_get_children(GTK_CONTAINER(pList));
  for (GList * iter1 = Ch1; iter1 != NULL; iter1 = iter1->next) {
     const char *type = gtk_widget_get_name(GTK_WIDGET(iter1->data));
     if(!g_strcmp0(type, "GtkSeparatorMenuItem")) {
		gtk_container_remove( GTK_CONTAINER(pList), GTK_WIDGET(iter1->data) );
        continue;
     }
     if(found_ok) continue;
	 GList *Ch2 = gtk_container_get_children(GTK_CONTAINER(iter1->data));
     for (GList *iter2 = Ch2; iter2 != NULL; iter2 = iter2->next) {
	    int i = 0;    
        GList *Ch3 = gtk_container_get_children(GTK_CONTAINER(iter2->data));
        for (GList *iter3 = Ch3; iter3 != NULL; iter3 = iter3->next) {
		   i++;		
	       const char *type = gtk_widget_get_name(GTK_WIDGET(iter3->data));
		   if(i == 1 && !g_strcmp0(type, "GtkLabel")) {	
		      char *lbl = strdup((char*)gtk_label_get_text(GTK_LABEL(iter3->data)));
			  char *token = strsep(&lbl, " ");
	          if(!g_strcmp0(p->name, token)) {
	             found_ok = true;
	             gtk_container_remove(GTK_CONTAINER(iter2->data), GTK_WIDGET(iter3->data));
	          }
	          continue;
	       }
	       if(!found_ok) break;
	       else
	          gtk_container_remove(GTK_CONTAINER(iter2->data), GTK_WIDGET(iter3->data));
        }       
        g_list_free(Ch3);
        if(found_ok) {
	       gtk_container_remove(GTK_CONTAINER(iter1->data), GTK_WIDGET(iter2->data));
	       break;
	    }   
     }       
     g_list_free(Ch2);
     if(found_ok) {
		GtkWidget *submenu = gtk_menu_item_get_submenu (iter1->data);
        GList *Ch4 = gtk_container_get_children(GTK_CONTAINER(submenu));
        for (GList * iter4 = Ch4; iter4 != NULL; iter4 = iter4->next) {
		   gtk_container_remove(GTK_CONTAINER(submenu), GTK_WIDGET(iter4->data));
        }       
        g_list_free(Ch4);
	    gtk_container_remove(GTK_CONTAINER(pList), GTK_WIDGET(iter1->data));
	    // Do not break here, continue removing separators instead
	    //break;
	 }  
  }
  
  g_list_free(Ch1);
  
  // retore separators
  Ch1 = gtk_container_get_children(GTK_CONTAINER(pList));
  for (GList * iter1 = Ch1; iter1 != NULL; iter1 = iter1->next) {
	 GList *Ch2 = gtk_container_get_children(GTK_CONTAINER(iter1->data));
     for (GList *iter2 = Ch2; iter2 != NULL; iter2 = iter2->next) {
        GList *Ch3 = gtk_container_get_children(GTK_CONTAINER(iter2->data));
        GList *first = g_list_first(Ch3);
	    char *lbl = strdup((char*)gtk_label_get_text(GTK_LABEL(first->data)));
		char *token = strsep(&lbl, " ");
		if(*prev && compare_alpha(token, prev) == 0) {
		   GtkWidget *pSeparator = gtk_separator_menu_item_new();
           gtk_menu_shell_insert(GTK_MENU_SHELL(pList), pSeparator, pos);
           pos++;
		}
	    memset(&prev, 0, sizeof(prev));  
		strncpy_t(prev, sizeof(prev), token, strlen(token));
     }      
     g_list_free(Ch2);
     pos++;  
  }
  g_list_free(Ch1);
  
  // determine whether or not the list is empty 
  Ch1 = gtk_container_get_children(GTK_CONTAINER(pList));
  if(g_list_length (Ch1) == 0) is_empty = true;
  g_list_free(Ch1);  

  gtk_widget_show_all(pList);
  if(is_empty && (showflags & AUTOHIDE)) ui_set_visible(0);
}

void ui_update(partinfo_t *p)
{
  bool found_ok = false;
  GList *Ch1 = gtk_container_get_children(GTK_CONTAINER(pList));
  for (GList * iter1 = Ch1; iter1 != NULL; iter1 = iter1->next) {
     const char *type = gtk_widget_get_name(GTK_WIDGET(iter1->data));
     if(!g_strcmp0(type, "GtkSeparatorMenuItem")) continue;
	 GList *Ch2 = gtk_container_get_children(GTK_CONTAINER(iter1->data));
     for (GList *iter2 = Ch2; iter2 != NULL; iter2 = iter2->next) {
	    int i = 0;    
        GList *Ch3 = gtk_container_get_children(GTK_CONTAINER(iter2->data));
        for (GList *iter3 = Ch3; iter3 != NULL; iter3 = iter3->next) {
		   i++;		
	       const char *type = gtk_widget_get_name(GTK_WIDGET(iter3->data));
		   if(g_strcmp0(type, "GtkLabel")) continue;	
		   char *lbl = strdup((char*)gtk_label_get_text(GTK_LABEL(iter3->data)));
		   char *token = strsep(&lbl, " ");
		   if(i == 1 && !g_strcmp0(p->name, token)) {
	          found_ok = true;
              char Item[PM_NAME_LEN+PM_LABEL_LEN+4]={0};
              // if name is not shown, label is shown - replaced by name if absent
              strncpy_t(Item, sizeof(Item), p->name, strlen(p->name));
              if((p->label[0]) || (showflags & SHOWNAME)) {
                 strcat(Item, " (");
                 strcat(Item, p->label);
                 strcat(Item, ")");
              }
              gtk_label_set_markup_with_mnemonic(GTK_LABEL(iter3->data), Item);
	       }
	       if(!found_ok) break;
	       if(i>2 && g_strcmp0(token, p->fstype) && g_strcmp0(token, p->size)) {
              char Item[PM_MNT_LEN+1]={0};
              if(!Item) 
                {
                   fprintf(stderr, _("%s: Memory allocation failure.\n"), progname);
                   exit(EXIT_FAILURE);
                }
              strncpy_t(Item, sizeof(Item), p->mnt, strlen(p->mnt));
              gtk_label_set_markup_with_mnemonic(GTK_LABEL(iter3->data), Item);
		   }
        }       
        g_list_free(Ch3);
	    if(found_ok) break;
     }       
     g_list_free(Ch2);
     if(found_ok) {
		GtkWidget *submenu = gtk_menu_item_get_submenu (iter1->data);
        GList *Ch4 = gtk_container_get_children(GTK_CONTAINER(submenu));
        for (GList * iter4 = Ch4; iter4 != NULL; iter4 = iter4->next) {
		   const char *lbl = gtk_menu_item_get_label(iter4->data);
		   if(!strcmp(lbl, "Mount")) {
			  if(p->nmounts)
			     gtk_widget_set_sensitive(iter4->data, FALSE);  
			  else
			     gtk_widget_set_sensitive(iter4->data, TRUE);
           }
		   else if(!strcmp(lbl, "Umount")) {
			  if(p->nmounts)
			     gtk_widget_set_sensitive(iter4->data, TRUE);  
			  else
			     gtk_widget_set_sensitive(iter4->data, FALSE);
           }
        }       
        g_list_free(Ch4);
	    break;
	 }    
  }
  g_list_free(Ch1);
  
  gtk_widget_show_all(pList);
}

void ui_msg(const char *msg)
{
  GtkWidget *dialog = NULL;
  // open a modal popup window and display the message;  
  GtkDialogFlags flags = GTK_DIALOG_DESTROY_WITH_PARENT;
  dialog = gtk_message_dialog_new (NULL,
                                 flags,
                                 GTK_MESSAGE_ERROR,
                                 GTK_BUTTONS_CLOSE,
                                 "%s", msg);

  gtk_window_set_title(GTK_WINDOW(dialog), "Message dialog");
  gtk_window_set_position (GTK_WINDOW(dialog), GTK_WIN_POS_MOUSE);
  gtk_dialog_run( GTK_DIALOG(dialog) );
  gtk_widget_destroy( dialog );
}

/*===================== The user interaction callbacks ======================*/

void on_click_open ( GtkWidget *pWidget, gpointer pData )
{
    partinfo_t *p = (partinfo_t *)pData;

    char cmd[512] = {0};
    char target[1024] = {0};
    FILE *pf = NULL;

    char cmdbuf[1024];
    const gchar *cmdline;

    GPid child_pid;
    GError *error = NULL;
    gboolean ret __attribute__((unused));
    gchar **open_in_file_manager = NULL;
  
    if( !p->nmounts ) 
        on_click_mount ( pWidget, pData );
	
    strncpy_t(cmd, sizeof(cmd), "/bin/findmnt -o TARGET -n /dev/", 
                strlen("/bin/findmnt -o TARGET -n /dev/"));
    strcat(cmd, p->name);
    
    pf = popen(cmd, "r");
    if (! pf)
      {
        fprintf(stderr, "%s: popen(): %s", progname, strerror(errno));
        exit(-errno);
      }
    
    if (fgets(target, sizeof(target), pf))
      {
        target[strcspn(target, "\n")] = '\0';
        if (target[0] == '/')
          {
            int rc = chdir(target);
            if (rc == -1)
              {
                fprintf(stderr, _("%s: chdir(%s): %s\n"), progname, target, strerror(errno));
                exit(-errno);
              }
          }  
      }
    pclose(pf);

    if(debug == -1)
      {
        debug = config_bool(Debug);
        if(debug == -1) debug = 0;
      }
  
    cmdline = config_helper(Open_in_File_Manager, p, cmdbuf, sizeof(cmdbuf));
    if(!cmdline)
      {
        ui_msg("No command helper.");
        return;
      }
    if(debug)
        fprintf(stderr, "External command to be issued: \"%s\"\n", cmdline);

    open_in_file_manager = g_strsplit(cmdbuf, " ", 6);
    ret = g_spawn_async (NULL, (gchar **)open_in_file_manager, NULL,
                      G_SPAWN_SEARCH_PATH, NULL, NULL,
                      &child_pid, &error);
    if (error != NULL)
    {
        g_error ("Spawning child failed: %s", error->message);
        return;
    }
    
    g_free(open_in_file_manager);

    chdir("/dev");
}

void on_click_term ( GtkWidget *pWidget, gpointer pData )
{
    partinfo_t *p = (partinfo_t *)pData;

    char cmd[512] = {0};
    char target[1024] = {0};
    FILE *pf = NULL;

    char cmdbuf[1024];
    const gchar *cmdline;

    GPid child_pid;
    GError *error = NULL;
    gboolean ret __attribute__((unused));
    gchar **open_in_terminal = NULL;
  
    if( !p->nmounts ) 
        on_click_mount ( pWidget, pData );
	
    strncpy_t(cmd, sizeof(cmd), "/bin/findmnt -o TARGET -n /dev/", 
                strlen("/bin/findmnt -o TARGET -n /dev/"));
    strcat(cmd, p->name);
    
    pf = popen(cmd, "r");
    if (! pf)
      {
        fprintf(stderr, "%s: popen(): %s", progname, strerror(errno));
        exit(-errno);
      }
    
    if (fgets(target, sizeof(target), pf))
      {
        target[strcspn(target, "\n")] = '\0';
        if (target[0] == '/')
          {
            int rc = chdir(target);
            if (rc == -1)
              {
                fprintf(stderr, _("%s: chdir(%s): %s\n"), progname, target, strerror(errno));
                exit(-errno);
              }
          }  
      }
    pclose(pf);

    if(debug == -1)
      {
        debug = config_bool(Debug);
        if(debug == -1) debug = 0;
      }
  
    cmdline = config_helper(Open_in_Terminal, p, cmdbuf, sizeof(cmdbuf));
    if(!cmdline)
      {
        ui_msg("No command helper.");
        return;
      }
    if(debug)
        fprintf(stderr, "External command to be issued: \"%s\"\n", cmdline);

    open_in_terminal = g_strsplit(cmdbuf, " ", 6);
    ret = g_spawn_async (NULL, (gchar **)open_in_terminal, NULL,
                      G_SPAWN_SEARCH_PATH, NULL, NULL,
                      &child_pid, &error);
    if (error != NULL)
    {
        g_error ("Spawning child failed: %s", error->message);
        return;
    }
    
    g_free(open_in_terminal);

    chdir("/dev");
}

void on_click_mount(GtkWidget *pWidget, gpointer pData)
{
    partinfo_t *p = (partinfo_t *)pData;

    char cmdbuf[1024];
    const gchar *cmdline;

    gchar *standard_output;
    gchar *standard_error;
    gint exit_status;
    gboolean ret __attribute__((unused));
    GError *error = NULL;
    gchar **mount_cmd = NULL;

    if(debug == -1)
      {
        debug = config_bool(Debug);
        if(debug == -1) debug = 0;
      }
  
    cmdline = config_helper(Mount, p, cmdbuf, sizeof(cmdbuf));
    if(!cmdline)
      {
        ui_msg("No command helper.");
        return;
      }
    if(debug)
        fprintf(stderr, "External command to be issued: \"%s\"\n", cmdline);
    
    mount_cmd = g_strsplit(cmdbuf, " ", 6);
    ret = g_spawn_sync(NULL, (gchar **)mount_cmd, NULL,
                G_SPAWN_SEARCH_PATH, NULL, NULL,
                &standard_output, &standard_error,
                &exit_status, &error);

    g_free(mount_cmd);

    if (strstr(standard_output, "Server reply - ERROR") || 
            strstr(standard_output, "Server reply - WARNING"))
      {
        char *token = strtok(standard_output, ":"); 
        token = strtok(NULL, "}");
        ui_msg(token);
      }
  
    mountpoints();

    g_free(standard_output);
    g_free(standard_error);
}

void on_click_umount ( GtkWidget *pWidget, gpointer pData )
{
    partinfo_t *p = (partinfo_t *)pData;

    char cmdbuf[1024];
    const gchar *cmdline;

    gchar *standard_output;
    gchar *standard_error;
    gint exit_status;
    gboolean ret __attribute__((unused));
    GError *error = NULL;
    gchar **unmount_cmd = NULL;

    if(debug == -1)
      {
        debug = config_bool(Debug);
        if(debug == -1) debug = 0;
      }
  
    cmdline = config_helper(Unmount, p, cmdbuf, sizeof(cmdbuf));
    if(!cmdline)
      {
        ui_msg("No command helper.");
        return;
      }
    if(debug)
        fprintf(stderr, "External command to be issued: \"%s\"\n", cmdline);
    
    unmount_cmd = g_strsplit(cmdbuf, " ", 6);
    ret = g_spawn_sync(NULL, (gchar **)unmount_cmd, NULL,
                G_SPAWN_SEARCH_PATH, NULL, NULL,
                &standard_output, &standard_error,
                &exit_status, &error);

    g_free(unmount_cmd);

    if (strstr(standard_output, "Server reply - ERROR") || 
            strstr(standard_output, "Server reply - WARNING"))
      {
        char *token = strtok(standard_output, ":"); 
        token = strtok(NULL, "}");
        ui_msg(token);
      }
  
    mountpoints();

    g_free(standard_output);
    g_free(standard_error);
}

void on_click_eject ( GtkWidget *pWidget, gpointer pData )
{
    partinfo_t *p = (partinfo_t *)pData;

    char cmdbuf[1024];
    const gchar *cmdline;

    gchar *standard_output;
    gchar *standard_error;
    gint exit_status;
    gboolean ret __attribute__((unused));
    GError *error = NULL;
    gchar **eject_cmd = NULL;

    if(debug == -1)
      {
        debug = config_bool(Debug);
        if(debug == -1) debug = 0;
      }
  
    cmdline = config_helper(Eject, p, cmdbuf, sizeof(cmdbuf));
    if(!cmdline)
      {
        ui_msg("No command helper.");
        return;
      }
    if(debug)
        fprintf(stderr, "External command to be issued: \"%s\"\n", cmdline);
    
    eject_cmd = g_strsplit(cmdbuf, " ", 6);
    ret = g_spawn_sync(NULL, (gchar **)eject_cmd, NULL,
                G_SPAWN_SEARCH_PATH, NULL, NULL,
                &standard_output, &standard_error,
                &exit_status, &error);

    g_free(eject_cmd);

    if (strstr(standard_output, "Server reply - ERROR") || 
            strstr(standard_output, "Server reply - WARNING"))
      {
        char *token = strtok(standard_output, ":"); 
        token = strtok(NULL, "}");
        ui_msg(token);
      }

    g_free(standard_output);
    g_free(standard_error);
}

